using System;
using System.IO;
using DynaPDF;

namespace text_extraction
{
	class TextExtraction
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            CTextExtraction parser = new CTextExtraction(pdf);
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We create no PDF file in this example

            // External CMaps should always be loaded when processing text from PDF files.
            // See the description of GetPageText() for further information.
            pdf.SetCMapDir(System.IO.Path.GetFullPath("../../../../Resource/CMap/"), DynaPDF.TLoadCMapFlags.lcmDelayed | DynaPDF.TLoadCMapFlags.lcmRecursive);

            // We avoid the conversion of pages to templates
            pdf.SetImportFlags(DynaPDF.TImportFlags.ifImportAll | DynaPDF.TImportFlags.ifImportAsPage);
            if (pdf.OpenImportFile("../../../../dynapdf_help.pdf", DynaPDF.TPwdType.ptOpen, null) < 0)
            {
               Console.Write("Input file \"../../../../../dynapdf_help.pdf\" not found!\n");
               Console.Read();
               return;
            }
            pdf.ImportPDFFile(1, 1.0, 1.0);
            pdf.CloseImportFile();

            // We flatten markup annotations and form fields so that we can extract the text of these objects too.
            pdf.FlattenAnnots(TAnnotFlattenFlags.affMarkupAnnots);
            pdf.FlattenForm();

            // We write the output file into the current directory.
            String outFile = Directory.GetCurrentDirectory() + "\\out.txt";
            parser.Open(outFile);

            int pageCount = pdf.GetPageCount();
            for (int i = 1; i <= pageCount; i++)
            {
               pdf.EditPage(i);
               parser.WritePageIdentifier(i);
               parser.ParsePage();
               pdf.EndPage();
            }
            parser.Close();
            Console.Write("Text successfully extracted to \"{0}\"!\n", outFile);
            System.Diagnostics.Process p = new System.Diagnostics.Process();
            p.StartInfo.FileName = outFile;
            p.Start();
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
